<div class="card">
<div class="card-header">
    <div class="row">
        <div class="col-md-6">
            <h5><?php echo e(__('lang.admin_rules_list')); ?></h5>
        </div>
        <div class="col-md-6">
            <h6 class="float-right">
                <?php if ($result->firstItem() != null) {?>
                <?php echo e(__('lang.admin_showing')); ?> <?php echo e($result->firstItem()); ?>-<?php echo e($result->lastItem()); ?>

                <?php echo e(__('lang.admin_of')); ?> <?php echo e($result->total()); ?> <?php }?>
            </h6>
        </div>
    </div>
</div>
<div class="card-body">
    <div class="table-responsive text-nowrap">
        <table class="table">
            <thead class="table-light">
                <tr class="text-nowrap">
                    <th><?php echo e(__('lang.admin_id')); ?></th>
                    <th><?php echo e(__('lang.admin_name')); ?></th>
                    <th><?php echo e(__('lang.admin_created_at')); ?></th>
                    <th><?php echo e(__('lang.admin_status')); ?></th>
                    <th><?php echo e(__('lang.admin_action')); ?></th>
                </tr>
            </thead>
            <tbody> 
                <?php if(count($result) > 0): ?>
                <?php $__currentLoopData = $result; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($row->id); ?></td>
                    <td><?php echo e($row->name); ?></td>
                    <td><?php echo e(\Helpers::commonDateFormate($row->created_at)); ?></td>
                    <td>
                        <?php if($row->status == 1): ?>
                        <a href="<?php echo e(url('admin/update-rules-column/'.$row->id)); ?>">
                            <span class="badge bg-success"><?php echo e(__('lang.admin_active')); ?></span></a>
                        <?php else: ?>
                        <a href="<?php echo e(url('admin/update-rules-column/'.$row->id)); ?>">
                            <span class="badge bg-warning"><?php echo e(__('lang.admin_deactive')); ?></span></a>
                        <?php endif; ?>
                    </td>
                    <td>
                        <div class="inline_action_btn">
                                <a class="edit_icon" href="javascript:void(0);"
                                    data-bs-toggle="offcanvas"
                                    data-bs-target="#edit-new-record_<?php echo e($row->id); ?>"
                                    aria-controls="edit-new-record_<?php echo e($row->id); ?>"
                                    title="<?php echo e(__('lang.admin_edit')); ?>"><i
                                        class="ti ti-pencil me-1"></i></a>
                                <a class="delete_icon" href="javascript:void(0);" title="<?php echo e(__('lang.admin_delete')); ?>"
                                    onclick="showDeleteConfirmation('rules' , <?php echo e($row->id); ?>)"
                                    ><i class="ti ti-trash me-1"></i></a
                                >
                        </div>
                    </td>

                    <!-- Modal to edit new record -->
                    <div class="offcanvas offcanvas-end" id="edit-new-record_<?php echo e($row->id); ?>">
                        <div class="offcanvas-header border-bottom">
                            <h5 class="offcanvas-title"
                                id="exampleModalLabel"><?php echo e(__('lang.admin_edit_feature')); ?></h5>
                            <button type="button" class="btn-close text-reset"
                                data-bs-dismiss="offcanvas" aria-label="Close"></button>
                        </div>
                        <div class="offcanvas-body flex-grow-1">
                            <form action="<?php echo e(url('admin/update-rules')); ?>" method="POST"
                                enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="id" value="<?php echo e($row->id); ?>">
                                <div class="col-sm-12">
                                    <label class="form-label"
                                        for="name"><?php echo e(__('lang.admin_name')); ?></label>
                                    <div class="input-group input-group-merge">
                                        <input type="text" id="basicFullname"
                                            class="form-control dt-full-name" name="name"
                                            value="<?php echo e($row->name); ?>"
                                            placeholder="<?php echo e(__('lang.admin_name_placeholder')); ?>"
                                            aria-label="Wi-Fi"
                                            aria-describedby="basicFullname2" required />
                                    </div>
                                </div>
                                <div class="col-sm-12 mt-3">
                                    <button type="submit"
                                        class="btn btn-primary data-submit me-sm-3 me-1"><?php echo e(__('lang.admin_save_changes')); ?></button>
                                    <button type="reset" class="btn btn-outline-secondary"
                                        data-bs-dismiss="offcanvas"><?php echo e(__('lang.admin_cancel')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <!--/ Modal to add new record -->
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                <tr>
                    <td colspan="5" class="record-not-found">
                        <span><?php echo e(__('lang.admin_no_data_found')); ?></span>
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<div class="card-footer">
    <div class="pagination" style="float: right;">
        <?php echo e($result->withQueryString()->links('pagination::bootstrap-4')); ?>

    </div>
</div>
</div><?php /**PATH /home/gyaanplant/mystaycation.gyaanplant.com/resources/views/admin/rules/table.blade.php ENDPATH**/ ?>