<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/


// ==================================Auth=======================================
Route::get('/','App\Http\Controllers\Auth\LoginController@getLoginView');
Route::get('/admin-login','App\Http\Controllers\Auth\LoginController@getLoginView');
Route::post('do-login', 'App\Http\Controllers\Auth\LoginController@authenticate');
Route::get('logout', 'App\Http\Controllers\Auth\LoginController@logout');

// =================================Admin=======================================
Route::group(['prefix' => 'admin','middleware' => 'auth'], function () {

            Route::get('/dashboard','App\Http\Controllers\Admin\DashboardController@index');
            Route::get('/','App\Http\Controllers\Admin\DashboardController@index');
            Route::get('/profile', 'App\Http\Controllers\Admin\UserController@profile');
            Route::post('/update-profile', 'App\Http\Controllers\Admin\UserController@updateProfile');
            

            /************************* Category Routing Starts Here **************************/
            Route::get('/category', 'App\Http\Controllers\Admin\CategoryController@index');
            Route::get('/add-category', 'App\Http\Controllers\Admin\CategoryController@create');
            Route::post('/save-category', 'App\Http\Controllers\Admin\CategoryController@store');
            Route::get('/edit-category/{id}', 'App\Http\Controllers\Admin\CategoryController@edit');
            Route::post('/update-category', 'App\Http\Controllers\Admin\CategoryController@update');
            Route::get('/delete-category/{id}', 'App\Http\Controllers\Admin\CategoryController@destroy');
            Route::get('/update-category-column/{id}', 'App\Http\Controllers\Admin\CategoryController@updateColumn');
            /************************* Category Routing End Here **************************/



            /************************* Subcategory Routing Starts Here ***********************/
            Route::get('/subcategory', 'App\Http\Controllers\Admin\SubcategoryController@index');
            Route::get('/add-subcategory', 'App\Http\Controllers\Admin\SubcategoryController@create');
            Route::post('/save-subcategory', 'App\Http\Controllers\Admin\SubcategoryController@store');
            Route::get('/edit-subcategory/{id}', 'App\Http\Controllers\Admin\SubcategoryController@edit');
            Route::post('/update-subcategory', 'App\Http\Controllers\Admin\SubcategoryController@update');
            Route::get('/delete-subcategory/{id}', 'App\Http\Controllers\Admin\SubcategoryController@destroy');
            Route::get('/update-subcategory-column/{id}', 'App\Http\Controllers\Admin\SubcategoryController@updateColumn');
            /*********************** Subcategory Routing End Here *************************/


            /************************* Bulk Routing Starts Here **********************/

            Route::get('/category-bulk', 'App\Http\Controllers\Admin\CategoryBulkController@categoryBulk');
            Route::post('/export-categories', 'App\Http\Controllers\Admin\CategoryBulkController@export');
            Route::get('/download-category-sample-without-data', 'App\Http\Controllers\Admin\CategoryBulkController@downloadSampleWithoutData');
            Route::get('/download-category-sample-with-data', 'App\Http\Controllers\Admin\CategoryBulkController@downloadSampleWithData');
             Route::post('/import-categories', 'App\Http\Controllers\Admin\CategoryBulkController@import');


            /************************* Bulk Routing End Here **************************/


            /************************* Addon Routing Starts Here **************************/
            
            Route::get('/addon', 'App\Http\Controllers\Admin\AddonController@index');
            Route::get('/add-addon', 'App\Http\Controllers\Admin\AddonController@create');
            Route::post('/save-addon', 'App\Http\Controllers\Admin\AddonController@store');
            Route::get('/edit-addon/{id}', 'App\Http\Controllers\Admin\AddonController@edit');
            Route::post('/update-addon', 'App\Http\Controllers\Admin\AddonController@update');
            Route::get('/delete-addon/{id}', 'App\Http\Controllers\Admin\AddonController@destroy');
            Route::get('/update-addon-column/{id}', 'App\Http\Controllers\Admin\AddonController@updateColumn');

            /************************* Addon Routing End Here **************************/


            /************************* Addon Routing Starts Here **************************/
            
            Route::get('/items', 'App\Http\Controllers\Admin\ItemController@index');
            Route::get('/add-item', 'App\Http\Controllers\Admin\ItemController@create');
            Route::post('/save-item', 'App\Http\Controllers\Admin\ItemController@store');
            Route::get('/edit-item/{id}', 'App\Http\Controllers\Admin\ItemController@edit');
            Route::post('/update-item', 'App\Http\Controllers\Admin\ItemController@update');
            Route::get('/delete-item/{id}', 'App\Http\Controllers\Admin\ItemController@destroy');
            Route::get('/update-item-column/{id}', 'App\Http\Controllers\Admin\ItemController@updateColumn');

            /************************* Addon Routing End Here **************************/

            /************************* Destination Routing Starts Here **************************/
            
            Route::get('/destination', 'App\Http\Controllers\Admin\DestinationController@index');
            Route::get('/add-destination', 'App\Http\Controllers\Admin\DestinationController@create');
            Route::post('/save-destination', 'App\Http\Controllers\Admin\DestinationController@store');
            Route::get('/edit-destination/{id}', 'App\Http\Controllers\Admin\DestinationController@edit');
            Route::post('/update-destination', 'App\Http\Controllers\Admin\DestinationController@update');
            Route::get('/delete-destination/{id}', 'App\Http\Controllers\Admin\DestinationController@destroy');
            Route::get('/update-destination-column/{id}', 'App\Http\Controllers\Admin\DestinationController@updateColumn');

            /************************* Destination Routing End Here **************************/

            /************************* Feature Routing Starts Here **************************/
            
            Route::get('/feature', 'App\Http\Controllers\Admin\FeatureController@index');
            Route::get('/add-feature', 'App\Http\Controllers\Admin\FeatureController@create');
            Route::post('/save-feature', 'App\Http\Controllers\Admin\FeatureController@store');
            Route::get('/edit-feature/{id}', 'App\Http\Controllers\Admin\FeatureController@edit');
            Route::post('/update-feature', 'App\Http\Controllers\Admin\FeatureController@update');
            Route::get('/delete-feature/{id}', 'App\Http\Controllers\Admin\FeatureController@destroy');
            Route::get('/update-feature-column/{id}', 'App\Http\Controllers\Admin\FeatureController@updateColumn');

            /************************* Feature Routing End Here **************************/


            /************************* Aminity Routing Starts Here **************************/
            
            Route::get('/aminity', 'App\Http\Controllers\Admin\AminityController@index');
            Route::get('/add-aminity', 'App\Http\Controllers\Admin\AminityController@create');
            Route::post('/save-aminity', 'App\Http\Controllers\Admin\AminityController@store');
            Route::get('/edit-aminity/{id}', 'App\Http\Controllers\Admin\AminityController@edit');
            Route::post('/update-aminity', 'App\Http\Controllers\Admin\AminityController@update');
            Route::get('/delete-aminity/{id}', 'App\Http\Controllers\Admin\AminityController@destroy');
            Route::get('/update-aminity-column/{id}', 'App\Http\Controllers\Admin\AminityController@updateColumn');

            /************************* Aminity Routing End Here **************************/
            
            /************************* Package Routing Starts Here **************************/
            
            Route::get('/package', 'App\Http\Controllers\Admin\PackageController@index');
            Route::get('/add-package', 'App\Http\Controllers\Admin\PackageController@create');
            Route::post('/save-package', 'App\Http\Controllers\Admin\PackageController@store');
            Route::get('/edit-package/{id}', 'App\Http\Controllers\Admin\PackageController@edit');
            Route::post('/update-package', 'App\Http\Controllers\Admin\PackageController@update');
            Route::get('/delete-package/{id}', 'App\Http\Controllers\Admin\PackageController@destroy');
            Route::get('/update-package-column/{id}', 'App\Http\Controllers\Admin\PackageController@updateColumn');

            /************************* Package Routing End Here **************************/
             
            /************************ User Routing Start Here *********************/
            Route::get('/customer', 'App\Http\Controllers\Admin\UserController@customerList');
            Route::post('/save-customer', 'App\Http\Controllers\Admin\UserController@store');
            Route::post('/update-customer', 'App\Http\Controllers\Admin\UserController@update');
            Route::get('/delete-customer/{id}', 'App\Http\Controllers\Admin\UserController@destroy');
            Route::get('/update-customer-column/{id}', 'App\Http\Controllers\Admin\UserController@updateColumn');
            Route::get('/view-customer/{id}', 'App\Http\Controllers\Admin\UserController@viewCustomer');
            
            
            /************************ Vendor Routing Start Here *********************/
            Route::get('/vendor', 'App\Http\Controllers\Admin\VendorController@vendorList');
            Route::post('/save-customer', 'App\Http\Controllers\Admin\UserController@store');
            Route::post('/update-vendor', 'App\Http\Controllers\Admin\VendorController@update');
            Route::get('/delete-vendor/{id}', 'App\Http\Controllers\Admin\VendorController@destroy');
            Route::get('/update-vendor-column/{id}', 'App\Http\Controllers\Admin\VendorController@updateColumn');
            Route::get('/view-customer/{id}', 'App\Http\Controllers\Admin\UserController@viewCustomer');
            
            /************************ Vendor Routing Ends Here *********************/
            
            /************************* Hotel Routing Starts Here **************************/
            
            Route::get('/hotel', 'App\Http\Controllers\Admin\HotelController@index');
            Route::get('/add-hotel', 'App\Http\Controllers\Admin\HotelController@create');
            Route::post('/save-hotel', 'App\Http\Controllers\Admin\HotelController@store');
            Route::get('/edit-hotel/{id}', 'App\Http\Controllers\Admin\HotelController@edit');
            Route::post('/update-hotel', 'App\Http\Controllers\Admin\HotelController@update');
            Route::get('/delete-hotel/{id}', 'App\Http\Controllers\Admin\HotelController@destroy');
            Route::get('/update-hotel-column/{id}', 'App\Http\Controllers\Admin\HotelController@updateColumn');
            
            // vendor
            Route::get('/vendors-hotel', 'App\Http\Controllers\Admin\HotelController@vendorIndex');
            Route::get('/edit-vendor-hotel/{id}', 'App\Http\Controllers\Admin\HotelController@vendorEdit');
            Route::post('/update-vendor-hotel', 'App\Http\Controllers\Admin\HotelController@vendorUpdate');

            /************************* Hotel Routing End Here **************************/
            
            /************************* Delete record Routing Starts Here **************************/
            Route::get('/delete-data/{id}', 'App\Http\Controllers\Admin\HotelController@destroyData');
            /************************* Delete record Routing End Here **************************/
            
            /*************************** Coupon Routing Starts Here ********************/
            
            Route::get('/coupon', 'App\Http\Controllers\Admin\CouponController@index');
            Route::get('/add-coupon', 'App\Http\Controllers\Admin\CouponController@create');
            Route::post('/save-coupon', 'App\Http\Controllers\Admin\CouponController@store');
            Route::get('/edit-coupon/{id}', 'App\Http\Controllers\Admin\CouponController@edit');
            Route::post('/update-coupon', 'App\Http\Controllers\Admin\CouponController@update');
            Route::get('/delete-coupon/{id}', 'App\Http\Controllers\Admin\CouponController@destroy');
            Route::get('/update-coupon-column/{id}', 'App\Http\Controllers\Admin\CouponController@updateColumn');

            /************************ Coupon Routing End Here *********************/
            
            /*************************** Rules Routing Starts Here ********************/
             
            Route::get('/rules', 'App\Http\Controllers\Admin\RulesController@index');
            Route::get('/add-rules', 'App\Http\Controllers\Admin\RulesController@create');
            Route::post('/save-rules', 'App\Http\Controllers\Admin\RulesController@store');
            Route::get('/edit-rules/{id}', 'App\Http\Controllers\Admin\RulesController@edit');
            Route::post('/update-rules', 'App\Http\Controllers\Admin\RulesController@update');
            Route::get('/delete-rules/{id}', 'App\Http\Controllers\Admin\RulesController@destroy');
            Route::get('/update-rules-column/{id}', 'App\Http\Controllers\Admin\RulesController@updateColumn');

            /************************ Rules Routing End Here *********************/
            
            /************************* Slider Routing Starts Here **************************/
            Route::get('/slider', 'App\Http\Controllers\Admin\SliderController@index');
            Route::get('/add-slider', 'App\Http\Controllers\Admin\SliderController@create');
            Route::post('/save-slider', 'App\Http\Controllers\Admin\SliderController@store');
            Route::get('/edit-slider/{id}', 'App\Http\Controllers\Admin\SliderController@edit');
            Route::post('/update-slider', 'App\Http\Controllers\Admin\SliderController@update');
            Route::get('/delete-slider/{id}', 'App\Http\Controllers\Admin\SliderController@destroy');
            Route::get('/update-slider-column/{id}', 'App\Http\Controllers\Admin\SliderController@updateColumn');
            /************************* Slider Routing End Here **************************/
            
            /************************* Offer Routing Starts Here **************************/
            Route::get('/offer', 'App\Http\Controllers\Admin\OfferController@offers');
            Route::post('/save-offer', 'App\Http\Controllers\Admin\OfferController@store');
            Route::get('/edit-offer/{id}', 'App\Http\Controllers\Admin\OfferController@edit');
            Route::post('/update-offer', 'App\Http\Controllers\Admin\OfferController@update');
            /************************* Offer Routing End Here **************************/
            
            /************************* Offer Routing Starts Here **************************/
            Route::get('/bookings', 'App\Http\Controllers\Admin\BookingController@index');
            Route::get('/delete-booking/{id}', 'App\Http\Controllers\Admin\BookingController@destroy');
            Route::get('/update-booking-column/{id}', 'App\Http\Controllers\Admin\BookingController@updateColumn');
            /************************* Offer Routing End Here **************************/
          
          
          
});