<!doctype html>

<html
  lang="en"
  class="light-style layout-navbar-fixed layout-menu-fixed layout-compact"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="../../assets/"
  data-template="vertical-menu-template-no-customizer">
  <head>
    <meta charset="utf-8" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Admin Dashboard</title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{asset('/assets/img/favicon/favicon.ico')}}" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&ampdisplay=swap"
      rel="stylesheet" />

    <!-- Icons -->
    <link rel="stylesheet" href="{{asset('/assets/vendor/fonts/fontawesome.css')}}" />
    <link rel="stylesheet" href="{{asset('/assets/vendor/fonts/tabler-icons.css')}}" />
    <link rel="stylesheet" href="{{asset('/assets/vendor/fonts/flag-icons.css')}}" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="{{asset('/assets/vendor/css/rtl/core.css')}}" />
    <link rel="stylesheet" href="{{asset('/assets/vendor/css/rtl/theme-default.css')}}" />
    <link rel="stylesheet" href="{{asset('/assets/css/demo.css')}}" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="{{asset('/assets/vendor/libs/node-waves/node-waves.css')}}" />
    <link rel="stylesheet" href="{{asset('/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css')}}" />
    <link rel="stylesheet" href="{{asset('/assets/vendor/libs/typeahead-js/typeahead.css')}}" />
    <link rel="stylesheet" href="{{asset('/assets/vendor/libs/apex-charts/apex-charts.css')}}" />
    <link rel="stylesheet" href="{{asset('/assets/vendor/libs/typeahead-js/typeahead.css')}}" />
    <link rel="stylesheet" href="{{asset('/assets/vendor/libs/animate-css/animate.css')}}" />

    <!-- sweet alert -->
    <link rel="stylesheet" href="{{asset('/assets/vendor/libs/sweetalert2/sweetalert2.css')}}" />

    <!-- toastr cdn -->
    <link rel="stylesheet" href="{{asset('/assets/vendor/libs/toastr/toastr.css')}}" />

    <!-- dahboard js page-->
    <link rel="stylesheet" href="{{asset('/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css')}}" />
    <link rel="stylesheet" href="{{asset('/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css')}}" />
    <link rel="stylesheet" href="{{asset('/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css')}}" />


    <!-- table page -->
    <link rel="stylesheet" href="{{asset('/assets/vendor/libs/select2/select2.css')}}" />
    <link rel="stylesheet" href="{{asset('/assets/vendor/libs/@form-validation/form-validation.css')}}" />
    <link rel="stylesheet" href="{{asset('/assets/vendor/libs/quill/typography.css')}}" />
    <link rel="stylesheet" href="{{asset('/assets/vendor/libs/quill/katex.css')}}" />
    <link rel="stylesheet" href="{{asset('/assets/vendor/libs/quill/editor.css')}}" />

    <!-- Page CSS -->

    <link rel="stylesheet" href="{{asset('/assets/vendor/css/pages/app-ecommerce.css')}}" />


    <!-- Helpers -->
    <script src="{{asset('/assets/vendor/js/helpers.js')}}"></script>
    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js')}} in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="{{asset('/assets/js/config.js')}}"></script>
  </head>
    <style type="text/css">
    /* Chrome, Safari, Edge, Opera */
    input::-webkit-outer-spin-button,
    input::-webkit-inner-spin-button {
    -webkit-appearance: none;
    margin: 0;
    }

    /* Firefox */
    input[type=number] {
    -moz-appearance: textfield;
    }
    .text-danger-msg{
    color: red;
    font-size: 12px;
    }
    .table-btn-css {
    float: right;
    margin-top: 20px;
    margin-right: 20px;
    }
    img.hide{
    height: 90px;
    width: 100px;
    margin-bottom: 5px;
    }
    .upload_image_show{
    height: 90px;
    width: 100px;
    margin-bottom: 5px;  
    }
    img.table_img {
    height: 50px;
    width: 50px;
    }
    .swal2-confirm{
    padding: 10px;
    border-radius: 10px;
    background-color: var(--bs-blue);
    color: white;
    border: none;
    }
    .swal2-cancel{
    padding: 10px;
    border-radius: 10px;
    background-color: #ff0000;
    color: white;
    border: none;
    }
    .float-right {
    float: right;
    }
    .display-inline-block {
    display: inline-block;
    }
    .margin-bottom-20 {
    margin-bottom: 20px;
    }
    td.record-not-found {
    text-align: center;
    }
    td.record-not-found span{
    color: red;
    }
    .image_upload_btn {
    color: #00cfe8;
    border-color: #00cfe8;
    background: transparent;
    border: 1px solid;
    padding: 4px 6px;
    cursor: pointer;
    border-radius: 6px;
    }
    .image_lable{
    display: block;
    }
    .accordion-body ul li{
        margin-bottom: 5px;
    }
    .edit_icon{
        color: black;
    }
    .delete_icon{
        color: red;
    }
    .cursor_pointer{
    cursor: pointer;
    }
    .avatar-upload {
    position: relative;
    max-width: 205px;
    margin: 50px auto;
    .avatar-edit {
        position: absolute;
        right: 12px;
        z-index: 1;
        top: 10px;
        input {
            display: none;
            + label {
                display: inline-block;
                width: 34px;
                height: 34px;
                margin-bottom: 0;
                border-radius: 100%;
                background: #FFFFFF;
                border: 1px solid transparent;
                box-shadow: 0px 2px 4px 0px rgba(0, 0, 0, 0.12);
                cursor: pointer;
                font-weight: normal;
                transition: all .2s ease-in-out;
                &:hover {
                    background: #f1f1f1;
                    border-color: #d6d6d6;
                }
            }
        }
    }
    .avatar-preview {
        width: 192px;
        height: 192px;
        position: relative;
        border-radius: 100%;
        border: 6px solid #F8F8F8;
        box-shadow: 0px 2px 4px 0px rgba(0, 0, 0, 0.1);
        > div {
            width: 100%;
            height: 100%;
            border-radius: 100%;
            background-size: cover;
            background-repeat: no-repeat;
            background-position: center;
        }
    }
}
    .pencil_for_img_upload{
        font-size: 30px;
        line-height: 30px;
    }
    </style>

  <body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">

    @include('admin.layouts.menu')

    @include('admin.layouts.header')

    <!-- BEGIN: Content-->
    @yield('content')
    <!-- END: Content-->

    <!-- BEGIN: Footer-->
    @include('admin.layouts.footer')


    <script>
        $(window).on('load', function() {

        @if(Session::has('success'))
            toastr['success']("{{ session('success') }}", {
                closeButton: true,
                tapToDismiss: false,
                rtl: isRtl
            });
        @endif

        @if(Session::has('error'))
            toastr['error']("{{ session('error') }}", {
                closeButton: true,
                tapToDismiss: false,
                rtl: isRtl
            });
        @endif

        @if(Session::has('info'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            };
            toastr.info("{{ session('info') }}");
        @endif

        @if(Session::has('warning'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            };
            toastr.warning("{{ session('warning') }}");
        @endif

        });

        function showImagePreview(input_id,preview_id,width,height) {
        $('#'+input_id).on('change', function() {
        var file = this.files[0];
        var reader = new FileReader();
        reader.onload = function(event) {
        var img = new Image();
        img.onload = function() {
        $("#"+preview_id).removeClass('hide');
        $('#'+preview_id).attr('src', event.target.result);             
        };
        img.src = event.target.result;
        };
        reader.readAsDataURL(file);
        });
        }


        function showDeleteConfirmation(pagename , itemId) {
        Swal.fire({
            title: "Are you sure?",
            text: "You won't be able to revert this!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, delete it!",
            customClass: {
                confirmButton: 'swal-confirm-button-class'
            }
        }).then((result) => {
            if (result.isConfirmed) {
               
                if(pagename == 'category'){
                  window.location.href = "/public/admin/delete-category/" + itemId;
                }else if(pagename == 'subcategory'){
                  window.location.href = "/public/admin/delete-subcategory/" + itemId;
                }else if(pagename == 'addon'){
                  window.location.href = "/public/admin/delete-addon/" + itemId;
                }else if(pagename == 'destination'){
                  window.location.href = "/public/admin/delete-destination/" + itemId;
                }else if(pagename == 'feature'){
                  window.location.href = "/public/admin/delete-feature/" + itemId;
                }else if(pagename == 'aminity'){
                  window.location.href = "/public/admin/delete-aminity/" + itemId;
                }else if(pagename == 'package'){
                  window.location.href = "/public/admin/delete-package/" + itemId;
                }else if(pagename == 'coupon'){
                  window.location.href = "/public/admin/delete-coupon/" + itemId;
                }else if(pagename == 'customer'){
                  window.location.href = "/public/admin/delete-customer/" + itemId;
                }else if(pagename == 'hotel'){
                  window.location.href = "/public/admin/delete-hotel/" + itemId;
                }else if(pagename == 'rules'){
                  window.location.href = "/public/admin/delete-rules/" + itemId;
                }else if(pagename == 'slider'){
                  window.location.href = "/public/admin/delete-slider/" + itemId;
                }else if(pagename == 'vendor'){
                  window.location.href = "/public/admin/delete-vendor/" + itemId;
                }else if(pagename == 'bookings'){
                  window.location.href = "/public/admin/delete-booking/" + itemId;
                }
                
            }
        });
    }

</script>

<script>
function appendData(pagename) {
    // Check if the page name is 'additional'
    if (pagename === 'additional') {
        // Append a new input field with delete button
        var newInputField = `
            <div class="row additional-input">
                <div class="col-10 mb-3">
                    <input type="text" class="form-control" name="additional_title[]" aria-label="{{__('lang.admin_additional_placeholder')}}" required placeholder="{{__('lang.admin_additional_placeholder')}}">
                </div>
                <div class="col-2">
                    <button type="button" class="btn btn-sm btn-danger" onclick="deleteInput(this, 'additional')"><i class="ti ti-trash me-1"></i></button>
                </div>
            </div>
        `;
        $('#additional-points-container').append(newInputField);
    }else if(pagename === 'cancellation_policy'){
        // Append a new input field with delete button
        var newInputField = `
            <div class="row cancellation-input">
                <div class="col-10 mb-3">
                    <input type="text" class="form-control" name="cancellation_policy_title[]" aria-label="{{__('lang.admin_cancellation_placeholder')}}" required placeholder="{{__('lang.admin_cancellation_placeholder')}}">
                </div>
                <div class="col-2">
                    <button type="button" class="btn btn-sm btn-danger" onclick="deleteInput(this, 'cancellation')"><i class="ti ti-trash me-1"></i></button>
                </div>
            </div>
        `;
        $('#cancellation-points-container').append(newInputField);
    }else if(pagename === 'specification'){
        // Append a new input field with delete button
        var newInputField = `
            <div class="row specification-input">
                <div class="col-10 mb-3">
                    <input type="text" class="form-control" name="specification_title[]" aria-label="{{__('lang.admin_specification_placeholder')}}" required placeholder="{{__('lang.admin_specification_placeholder')}}">
                </div>
                <div class="col-2">
                    <button type="button" class="btn btn-sm btn-danger" onclick="deleteInput(this, 'specification')"><i class="ti ti-trash me-1"></i></button>
                </div>
            </div>
        `;
        $('#specification-points-container').append(newInputField);
    }else if(pagename === 'packages'){
        // Append a new input field with delete button
        var newInputField = `
            <div class="card mb-4 packages-input">
                      <div class="card-header">
                        <div class="row">
                        <div class="col-10">
                        <h5 class="card-title mb-0">{{__('lang.admin_packages_info')}}</h5>
                        </div>
                        <div class="col-2">
                            <button type="button" class="btn btn-sm btn-danger" onclick="deleteInput(this, 'packages')"><i class="ti ti-trash me-1"></i></button>
                        </div>
                        </div>
                      </div>
                      <div class="card-body">
                          
                        <!-- Package -->
                        <div class="mb-3 col ecommerce-select2-dropdown">
                          <label
                            class="form-label mb-1 d-flex justify-content-between align-items-center"
                            for="category-org">
                          <span>{{__('lang.admin_package')}}</span><a href="{{url('admin/package')}}" class="fw-medium">{{__('lang.admin_add_new_package')}}</a>
                          </label>
                          <select class="select2 form-select" name="packages_id[]">
                                <option value="">{{__('lang.admin_select_package')}}</option>
                                @if(isset($package_data) && !is_null($package_data) && count($package_data))
                                    @foreach($package_data as $package)
                                        <option value="{{$package->id}}">{{$package->name}}</option>
                                    @endforeach
                                @endif

                          </select>
                        </div>
                        
                        <!-- Item Price -->
                        <div class="mb-3">
                          <label class="form-label" for="ecommerce-product-price">{{__('lang.admin_item_price')}} <span class="required">*</span></label>
                          <input
                            type="number"
                            name="package_price[]"
                            class="form-control"
                            id="price_id"
                            placeholder="{{__('lang.admin_item_price')}}"
                            aria-label="{{__('lang.admin_item_price')}}" required/>
                        </div>

                        <!-- Type -->
                        <div class="mb-3 col ecommerce-select2-dropdown">
                          <label class="form-label mb-1" for="vendor">{{__('lang.admin_type')}} <span class="required">*</span></label>
                          <select class="select2 form-select" name="package_type[]">
                            <option value="">{{__('lang.admin_select_type')}}</option>
                                @if(isset($getType) && !is_null($getType) && count($getType))
                                    @foreach($getType as $value => $label)
                                        <option value="{{ $value }}">{{ $label }}</option>
                                    @endforeach
                                @endif

                          </select>
                        </div>
                          
                        <!-- Adults -->
                        <div class="mb-3 col ecommerce-select2-dropdown">
                          <label class="form-label mb-1" for="vendor">{{__('lang.admin_guest')}}</label>
                          <select class="select2 form-select" name="package_guest[]">
                                <option value="">{{__('lang.admin_select_guest')}}</option>
                                {!! \Helpers::fiftyCountData() !!}
                          </select>
                        </div>
                        
                        <!-- Date -->
                        <div class="mb-3">
                            <label class="form-label" for="ecommerce-product-price">{{__('lang.admin_date')}} <span class="required">*</span></label>
                            <input
                                type="date"
                                name="package_date[]"
                                class="form-control"
                                id="price_id"
                                placeholder="{{__('lang.admin_date')}}"
                                aria-label="{{__('lang.admin_date')}}"
                                min="{{ date('Y-m-d') }}"
                                required/>
                        </div>


                      </div>
                    </div>
        `;
        $('#packages-points-container').append(newInputField);
    }
}

function deleteInput(button, pagename) {
    // Check if the page name is 'additional'
    if (pagename === 'additional') {
        // Remove the parent div containing the input field and delete button
        $(button).closest('.additional-input').remove();
    }else if (pagename === 'cancellation') {
        // Remove the parent div containing the input field and delete button
        $(button).closest('.cancellation-input').remove();
    }else if (pagename === 'specification') {
        // Remove the parent div containing the input field and delete button
        $(button).closest('.specification-input').remove();
    }else if (pagename === 'packages') {
        // Remove the parent div containing the input field and delete button
        $(button).closest('.packages-input').remove();
    }
}
</script>

<!-- Category Bulk Export -->
<script type="text/javascript">
$(document).on('change','.export_select_tag',function(){
var val = $(this).val();
    if(val == 'date_wise'){
    $('.id_wise_input').css('display','none');
    $('.date_wise_input').css('display','block');
    }else if(val == 'id_wise'){
    $('.date_wise_input').css('display','none');
    $('.id_wise_input').css('display','block');
    }else{
    $('.date_wise_input').css('display','none');
    $('.id_wise_input').css('display','none');
    }
});
</script>

<!-- ckeditor -->
<script type="text/javascript">
    ClassicEditor
    .create(document.querySelector('#editor'), {
        minHeight: '300px'
    })
    .then(editor => {
        editorInstance = editor;
        const prefilledValue = document.getElementById('seo_description').value;
        editor.setData(prefilledValue);
        // Set the prefilled value on keyup event
        editor.model.document.on('change', () => {
            const updatedValue = editor.getData();
            var stripedHtml = updatedValue.replace(/<[^>]+>/g, '');
            document.getElementById('seo_description').value = stripedHtml;
        });
    }).catch(error => {
        console.log(error);
    });
</script>
<!-- image preview -->
<script type="text/javascript">
function readURL(input) {
    if (input.files && input.files[0]) {
        var reader = new FileReader();
        reader.onload = function(e) {
            $('#imagePreview').css('background-image', 'url('+e.target.result +')');
            $('#imagePreview').hide();
            $('#imagePreview').fadeIn(650);
        }
        reader.readAsDataURL(input.files[0]);
    }
}
$("#imageUpload").change(function() {
    readURL(this);
});


function readURLTwo(input) {
    if (input.files && input.files[0]) {
        var reader = new FileReader();
        reader.onload = function(e) {
            $('#imagePreviewTwo').css('background-image', 'url('+e.target.result +')');
            $('#imagePreviewTwo').hide();
            $('#imagePreviewTwo').fadeIn(650);
        }
        reader.readAsDataURL(input.files[0]);
    }
}
$("#imageUploadTwo").change(function() {
    readURLTwo(this);
});

function readURLThree(input) {
    if (input.files) {
        var fileArray = Array.from(input.files); // Convert FileList to Array
        var previewContainer = document.getElementById('imagePreviewContainer');
        previewContainer.innerHTML = ''; // Clear existing previews

        fileArray.forEach(file => {
            var reader = new FileReader();

            reader.onload = function(e) {
                // Create a new div for each image
                var imagePreview = document.createElement('div');
                imagePreview.className = 'image-preview';
                imagePreview.style.backgroundImage = 'url(' + e.target.result + ')';
                previewContainer.appendChild(imagePreview);
            }

            reader.readAsDataURL(file);
        });
    }
}
// Ensure the function readURLThree is called
document.getElementById("imageUploadThree").addEventListener("change", function() {
    readURLThree(this);
});

</script>
    