@extends('admin.layouts.app')
@section('content')

<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">


    <form action="{{url('admin/save-item')}}" method="POST" enctype="multipart/form-data">
        @csrf

        <div class="row">
            <div class="col-md-6">
                <h4 class="py-3 mb-4">
                  <span class="text-muted fw-light">
                    <a href="{{url('admin/dashboard')}}">{{__('lang.admin_dashboard')}}</a> /
                  </span><span class="text-muted fw-light">
                    <a href="{{url('admin/items')}}">{{__('lang.admin_item_list')}}</a> /
                  </span>
                  {{__('lang.admin_add_item_form')}}</h4>
            </div>
            <div class="col-md-6">
                <div class="table-btn-css">
                    <button type="submit" class="btn btn-primary waves-effect waves-light">
                        <span class="ti-xs ti ti-plus me-1"></span>{{__('lang.admin_submit')}}
                    </button>
                </div>
            </div>
        </div>
        

        <!-- product add -->
          <div class="row">
                  <!-- First column-->
                  <div class="col-12 col-lg-8">

                    <!-- Product Information -->
                    <div class="card mb-4">
                      <div class="card-header">
                        <h5 class="card-tile mb-0">{{__('lang.admin_item_information')}}</h5>
                      </div>
                      <div class="card-body">
                        <!-- name -->
                        <div class="mb-3">
                          <label class="form-label" for="ecommerce-product-name">{{__('lang.admin_name')}}</label>
                          <input
                            type="text"
                            class="form-control"
                            id="ecommerce-product-name"
                            placeholder="{{__('lang.admin_item_name_placeholder')}}"
                            name="name"
                            aria-label="{{__('lang.admin_name')}}" />
                        </div>


                        <!-- Image -->
                        <div class="mb-3">
                            <label class="form-label image_lable" for="ecommerce-category-image">{{__('lang.admin_image')}}</label>
                            <div class="avatar-upload">
                                <div class="avatar-edit">
                                        <input type='file' id="imageUpload" accept=".png, .jpg, .jpeg" name="image" />
                                        <label for="imageUpload"><i class="ti ti-pencil me-1 pencil_for_img_upload"></i></label>
                                    </div>
                                    <div class="avatar-preview">
                                        <div id="imagePreview" style='background-image: url("public/uploads/no-image.png");'>
                                        </div>
                                    </div>
                            </div>
                        </div>

                        <!-- Description -->
                        <div class="mb-3">
                            <label class="form-label" for="short_description">{{__('lang.admin_description')}} </label>
                            <textarea class="form-control" name="short_description" id="editor" placeholder="{{__('lang.admin_description_placeholder')}}" row="6"></textarea>
                        </div>

                        <!-- Item Type -->
                        <div class="mb-3 col ecommerce-select2-dropdown">
                          <label class="form-label mb-1" for="vendor">{{__('lang.admin_item_type')}}</label>
                          <select class="select2 form-select" name="discount_type">
                            <option value="">{{__('lang.admin_select_item_type')}}</option>
                            <option value="veg">Veg</option>
                            <option value="nonveg">Non Veg</option>
                          </select>
                        </div>

                      </div>
                    </div>
                    <!-- /Product Information -->

                    <!-- Availability -->
                    <div class="card mb-4">
                      <div class="card-header">
                        <h5 class="card-title mb-0">{{__('lang.admin_item_availability')}}</h5>
                      </div>
                      <div class="card-body row">
                        <!-- start time -->
                        <div class="mb-3 col-md-6">
                            <label class="form-label" for="ecommerce-product-name">{{__('lang.admin_item_avai_time_start')}}</label>
                            <input type="time" class="form-control" name="availability_start_time">
                        </div>
                         
                        <!-- end time -->
                        <div class="mb-3 col-md-6">
                            <label class="form-label" for="ecommerce-product-name">{{__('lang.admin_item_avai_end_start')}}</label>
                            <input type="time" class="form-control" name="availability_end_time">
                        </div>
                      </div>
                    </div>
                    <!-- /Availability -->
  
                  </div>
                  <!-- /Second column -->

                  <!-- Second column -->
                  <div class="col-12 col-lg-4">

                    <!-- Pricing Card -->
                    <div class="card mb-4">
                      <div class="card-header">
                        <h5 class="card-title mb-0">{{__('lang.admin_pricing')}}</h5>
                      </div>
                      <div class="card-body">

                        <!-- Item Price -->
                        <div class="mb-3">
                          <label class="form-label" for="ecommerce-product-price">{{__('lang.admin_item_price')}}</label>
                          <input
                            type="number"
                            name="price"
                            class="form-control"
                            id="ecommerce-product-price"
                            placeholder="{{__('lang.admin_item_price')}}"
                            aria-label="{{__('lang.admin_item_price')}}" />
                        </div>

                        <!-- Discount Type -->
                        <div class="mb-3 col ecommerce-select2-dropdown">
                          <label class="form-label mb-1" for="vendor">{{__('lang.admin_item_discount_type')}}</label>
                          <select class="select2 form-select" name="discount_type">
                            <option value="">{{__('lang.admin_select_item_discount_type')}}</option>
                            <option value="amount">Amount</option>
                            <option value="percent">Percent</option>
                          </select>
                        </div>

                        <!-- Discounted Price -->
                        <div class="mb-3">
                          <label class="form-label" for="ecommerce-product-discount-price"> {{__('lang.admin_item_discount')}}</label>
                          <input
                            type="number"
                            name="discount"
                            class="form-control"
                            id="ecommerce-product-discount-price"
                            placeholder="{{__('lang.admin_item_discount')}}"
                            aria-label="Product discounted price" />
                        </div>

                        <!-- Maximum Purchase Quantity Limit  -->
                        <div class="mb-3">
                          <label class="form-label" for="ecommerce-product-discount-price"> {{__('lang.admin_item_maximum_purchase_quantity_limit')}}</label>
                          <input
                            type="number"
                            name="maximum_purchase_quantity_limit"
                            class="form-control"
                            id="ecommerce-product-discount-price"
                            placeholder="{{__('lang.admin_item_maximum_purchase_quantity_limit')}}"
                            aria-label="{{__('lang.admin_item_maximum_purchase_quantity_limit')}}" />
                        </div>
        
                      </div>
                    </div>
                    <!-- /Pricing Card -->


                    <!-- Resto and Cat Info -->
                    <div class="card mb-4">
                      <div class="card-header">
                        <h5 class="card-title mb-0">{{__('lang.admin_resto_and_cat_info')}}</h5>
                      </div>
                      <div class="card-body">

                        <!-- Restaurant -->
                        <div class="mb-3 col ecommerce-select2-dropdown">
                          <label class="form-label mb-1" for="vendor">{{__('lang.admin_restaurant')}}</label>
                          <select class="select2 form-select" name="restaurant_id">
                            <option value="">{{__('lang.admin_select_restaurant')}}</option>
                          </select>
                        </div>

                        <!-- Category -->
                        <div class="mb-3 col ecommerce-select2-dropdown">
                          <label
                            class="form-label mb-1 d-flex justify-content-between align-items-center"
                            for="category-org">
                            <span>{{__('lang.admin_category')}}</span><a href="{{url('admin/category')}}" class="fw-medium">{{__('lang.admin_add_new_category')}}</a>
                          </label>
                          <select class="select2 form-select" name="category_id">
                            <option value="">{{__('lang.admin_select_category')}}</option>
                            @foreach($category_data as $row)
                            <option value="{{$row->id}}">{{$row->name}}</option>
                            @endforeach
                          </select>
                        </div>

                        <!-- Subcategory -->
                        <div class="mb-3 col ecommerce-select2-dropdown">
                          <label class="form-label mb-1" for="collection">{{__('lang.admin_subcategory')}} </label>
                          <select class="select2 form-select" name="subcategory_id">
                            <option value="">{{__('lang.admin_select_subcategory')}}</option>
                            @foreach($subcategory_data as $row)
                            <option value="{{$row->id}}">{{$row->name}}</option>
                            @endforeach
                          </select>
                        </div>


                        <!-- Addon -->
                        <div class="mb-3 col ecommerce-select2-dropdown">
                          <label class="form-label mb-1" for="status-org"> {{__('lang.admin_addon')}}</label>
                          <select class="select2 form-select" name="addon_id">
                            <option value="">{{__('lang.admin_select_addon')}}</option>
                            @foreach($addon_data as $row)
                            <option value="{{$row->id}}">{{$row->name}}</option>
                            @endforeach
                          </select>
                        </div>

                      </div>
                    </div>
                    <!-- /Resto and Cat Info -->

                  </div>
                  <!-- /Second column -->
                </div>
        <!-- end product add -->

    </form>
       

    </div>
    <!-- / Content -->
</div>
<!-- Content wrapper -->

@endsection
