@extends('admin.layouts.app')
@section('content')

<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">

        <div class="row">
            <div class="col-md-6">
                <h4 class="py-3 mb-4">
                  <span class="text-muted fw-light">
                    <a href="{{url('admin/dashboard')}}">{{__('lang.admin_dashboard')}}</a> /
                  </span><span class="text-muted fw-light">
                    <a href="{{url('admin/customer')}}">{{__('lang.admin_customer_list')}}</a> /
                  </span>
                  {{__('lang.admin_view_customer_form')}}</h4>
            </div>
             <div class="col-md-6">
                <div class="table-btn-css">
                    <a type="reset" class="btn btn-outline-secondary" href="{{url('admin/customer')}}">{{__('lang.admin_back')}}</a>
                </div>
            </div>
        </div>  

    <!-- boxes -->
      <div class="row">
          <!-- box-1 -->
          <div class="col-md-12 row">
              <div class="col-sm-6 col-lg-6 mb-4">
                <a href="{{ url('admin/wallet?customer_id=' . Request::segment(3)) }}">
                <div class="card card-border-shadow-warning">
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-2 pb-1">
                            <div class="avatar me-2">
                                <span class="avatar-initial rounded bg-label-warning"><i class="ti ti-wallet ti-md"></i></span>
                            </div>
                            <h4 class="ms-1 mb-0">{{$finalAmount}}</h4>
                        </div>
                        <p class="mb-1">{{__('lang.admin_customer_wallet_balance')}}</p>
                    </div>
                </div>
                </a>
            </div>
            <div class="col-sm-6 col-lg-6 mb-4">
                <div class="card card-border-shadow-info">
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-2 pb-1">
                            <div class="avatar me-2">
                                <span class="avatar-initial rounded bg-label-info"><i class="ti ti-shopping-cart ti-md"></i></span>
                            </div>
                            <h4 class="ms-1 mb-0">0</h4>
                        </div>
                        <p class="mb-1">{{__('lang.admin_total_order')}}</p>
                    </div>
                </div>
            </div>
          </div>
          <!-- / box-1 -->
      </div>
    <!-- /boxes -->


    <!-- Cus info -->
    <div class="row">
        <!--  column 1-->
        <div class="col-12 col-lg-12">
            <!-- Basic Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-tile mb-0">{{__('lang.admin_customer_info')}} <i class="menu-icon tf-icons ti ti-user"></i></h5>
                </div>
                <div class="card-body row">
                    <div class="col-md-12 row">

                        <div class="col-md-12 mt-2">
                          <span class="d-inline-flex">{{__('lang.admin_customer_id')}} : <h6 class="margin-left">#{{$result->id}}</h6></span>

                        <div class="col-md-12 mt-2">
                          <span class="d-inline-flex">{{__('lang.admin_customer_name')}} : <h6 class="margin-left"> {{$result->name}}</h6></span>
                        </div>

                        <div class="col-md-12 mt-2">
                          <span class="d-inline-flex">{{__('lang.admin_customer_email')}} : <h6 class="margin-left"> {{$result->email}}</h6></span>

                        <div class="col-md-12 mt-2">
                          <span class="d-inline-flex">{{__('lang.admin_customer_phone')}} : <h6 class="margin-left"> {{$result->phone}}</h6></span>
                        </div>
                    </div>
                </div>
            </div>
        <!-- /Basic Information -->
        </div>
        <!-- / column 1-->


      </div>
  <!-- end Cus info -->


    </div>
    <!-- / Content -->
</div>
<!-- Content wrapper -->

@endsection
