<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('booking_guest')) {
            Schema::create('booking_guest', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('booking_id')->default(0);
                $table->string('full_name');
                $table->string('gender');
                $table->string('phone');
                $table->string('email');
                $table->string('id_card_type');
                $table->string('card_number');
                $table->timestamps();

                // Adding indexes
                $table->index('full_name');
                $table->index('phone');
                $table->index('email');
                
                // Foreign key constraints
                $table->foreign('booking_id')->references('id')->on('bookings')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('booking_guest');
    }
};
