<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('hotel_packages')) {
            Schema::create('hotel_packages', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('hotel_id')->default(0);
                $table->unsignedBigInteger('packages_id')->default(0);
                $table->string('guest', 50)->nullable();
                $table->integer('price')->nullable();
                $table->enum('type', ['Day', 'Night'])->default('Night');
                $table->string('date',16)->nullable();
                $table->timestamps();
                $table->softDeletes();
                
                // Foreign key constraints
                $table->foreign('hotel_id')->references('id')->on('hotels')->onDelete('cascade');
                $table->foreign('packages_id')->references('id')->on('packages')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('hotel_packages');
    }
};
