<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('addons')) {
            Schema::create('items', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('restaurant_id')->default(0);
                $table->unsignedBigInteger('category_id')->default(0);
                $table->unsignedBigInteger('subcategory_id')->default(0);
                $table->unsignedBigInteger('addon_id')->default(0);
                $table->string('name',100)->nullable();
                $table->text('short_description')->nullable();
                $table->text('image',50)->nullable();
                $table->enum('type',['veg','nonveg'])->default('veg');
                $table->string('availability_start_time',30)->nullable();
                $table->string('availability_end_time',30)->nullable();
                $table->integer('price')->nullable();
                $table->enum('discount_type',['amount','percent'])->default('amount');
                $table->integer('discount')->nullable();
                $table->integer('maximum_purchase_quantity_limit')->nullable();
                $table->enum('status',[1,0])->default(1);
                $table->timestamps();

            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('items');
    }
};
