<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('users')) {
            Schema::create('users', function (Blueprint $table) {
                $table->id();
                $table->enum('type',['admin','user'])->default('user');
                $table->enum('device_type', ['web','app'])->default('web');
                $table->string('language_code')->nullable();
                $table->string('name');
                $table->string('image')->nullable();
                $table->string('email')->nullable();
                $table->string('password')->nullable();
                $table->string('phone', 25)->nullable();
                $table->string('token')->nullable();
                $table->string('adharcard_image')->nullable();
                $table->tinyInteger('status')->default(1);
                $table->tinyInteger('is_verified')->default(1);
                $table->tinyInteger('enable_notification')->default(1);
                $table->integer('otp')->default(0);
                $table->integer('role_id')->default(0);
                $table->string('remember_token', 100)->nullable();
                $table->timestamp('email_verified_at')->nullable();
                $table->timestamps();
                $table->softDeletes();
                // Adding indexes
                $table->index('type');
                $table->index('language_code');
                $table->index('name');
                $table->index('email');
                $table->index('phone');
                $table->index('otp');
                $table->index('role_id');
                $table->index('email_verified_at');
                $table->index('status');
                $table->index('created_at');
                $table->index('updated_at');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
