<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RecentlyViewedHotel extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'device_token',
        'hotel_id',
    ];

    // Define relationship to the Hotel model
    public function hotel()
    {
        return $this->belongsTo(Hotel::class);
    }

    // Define relationship to the User model
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
