<?php

namespace App\Http\Controllers\API\Vendor;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Auth;
use Validator;
use App\Models\Vendor;
use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;
use Symfony\Component\HttpFoundation\Response;


class VendorProfileAPIController extends Controller
{
    private $language;
    public function __construct()
    {
        // No need to call parent::__construct() here
        $this->language = request()->header('language-code') && request()->header('language-code') != '' ? request()->header('language-code') : 'en';
    }
    
    /**
     *  User profile
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    function vendorProfile(Request $request){
        try{
            if($request->vendor){
                $vendor = Vendor::where('id',$request->vendor->id)->first();
                if($vendor){
                    if($vendor->image!=''){
                        $vendor->image = url('uploads/vendor/profile_pic/'.$vendor->image);
                    }
                }
                if($vendor){
                    if($vendor->id_card_image!=''){
                        $vendor->id_card_image = url('uploads/vendor/id_card_image/'.$vendor->id_card_image);
                    }
                }
                $response = $this->sendResponse($vendor, __('lang.message_data_retrived_successfully'));            
                return $response;
            }
            return $this->sendError(__('lang.message_user_not_found'));
        }catch(RepositoryException $e){
            return $this->sendError($e->getMessage());
        }
    }
    
    
    /**
     *  update profile
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function doUpdateProfile(Request $request)
    {
        try{
            if($request->vendor){
                $post = $request->all();
                $vendor = $request->vendor;
                $post['image'] = $request->file('image');
                $postData = array(
                    'updated_at' => date("Y-m-d H:i:s")
                );
                if(isset($post['email'])){
                    $checkuser = Vendor::where('email', $request->input('email'))->where('id','!=',$vendor->id)->first();
                    if($checkuser) {
                        return $this->sendError(__('lang.message_email_already_exist'));
                    }
                    $postData['email'] = $post['email'];
                }                
                if(isset($post['name'])){
                    $postData['name'] = $post['name'];
                }
                if(isset($post['phone'])){
                    $postData['phone'] = $post['phone'];
                }                
                if(isset($post['image'])){
                    $uploadImage = \Helpers::uploadFiles($request->file('image'),'vendor/profile_pic/');
                    if($uploadImage['status']==true)
                    {
                        $postData['image'] = $uploadImage['file_name'];
                    }
                }
                if(isset($post['id_card_image'])){
                    $uploadImage = \Helpers::uploadFiles($request->file('id_card_image'),'vendor/id_card_image/');
                    if($uploadImage['status']==true)
                    {
                        $postData['id_card_image'] = $uploadImage['file_name'];
                    }
                }
                Vendor::where('id',$vendor->id)->update($postData);
                $vendorProfile = Vendor::where('id',$vendor->id)->first();
                if($vendorProfile){
                    if($vendorProfile->image!=''){
                        $vendorProfile->image = url('uploads/vendor/profile_pic/'.$vendorProfile->image);
                    }
                }
                if($vendorProfile){
                    if($vendorProfile->id_card_image!=''){
                        $vendorProfile->id_card_image = url('uploads/vendor/id_card_image/'.$vendorProfile->id_card_image);
                    }
                }
                return $this->sendResponse($vendorProfile, __('lang.message_profile_updated_successfully'));
            }
            return $this->sendError(__('lang.message_user_not_found'));
        } catch (\Exception $ex) {
            return $this->sendError($ex->getMessage());
        }
    }
    
    /**
    * Change Password
    *
    * @param  \Illuminate\Http\Request  $request
    * @return \Illuminate\Http\Response
    */
    public function doChangePassword(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'old_password' => 'required',
                'new_password' => 'required|min:6',
                'confirm_password' => 'required|same:new_password',
            ]);
    
            if ($validator->fails()) {
                return $this->sendError(__('lang.message_required_message'), $validator->errors());
            }
    
            if ($request->vendor) {
                $vendor = $request->vendor;
                $postData = [
                    'updated_at' => now(),
                ];
    
                // Verify old password
                $checkuser = Vendor::where('id', $vendor->id)->first();
                if (!$checkuser || !Hash::check($request->input('old_password'), $checkuser->password)) {
                    return $this->sendError(__('lang.message_old_password_is_not_matched'));
                }
    
                // Update password
                $postData['password'] = Hash::make($request->input('new_password'));
    
                Vendor::where('id', $vendor->id)->update($postData);
                $vendorProfile = Vendor::where('id', $vendor->id)->first();
                return $this->sendResponse($vendorProfile, __('lang.message_password_changed_successfully'));
            }
    
            return $this->sendError(__('lang.message_user_not_found'));
        } catch (\Exception $ex) {
            return $this->sendError($ex->getMessage());
        }
    }

    
}
