<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Auth;
use Validator;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;
use Symfony\Component\HttpFoundation\Response;


class ProfileAPIController extends Controller
{
    private $language;
    public function __construct()
    {
        // No need to call parent::__construct() here
        $this->language = request()->header('language-code') && request()->header('language-code') != '' ? request()->header('language-code') : 'en';
    }
    
    /**
     *  User profile
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    function userProfile(Request $request){
        try{
            if($request->user){
                $user = User::where('id',$request->user->id)->where('status',1)->first();
                if($user){
                    if($user->image!=''){
                        $user->image = url('uploads/user/profile_pic/'.$user->image);
                    }
                }
                if($user){
                    if($user->adharcard_image!=''){
                        $user->adharcard_image = url('uploads/user/adharcard_image/'.$user->adharcard_image);
                    }
                }
                $response = $this->sendResponse($user, __('lang.message_data_retrived_successfully'));            
                return $response;
            }
            return $this->sendError(__('lang.message_user_not_found'));
        }catch(RepositoryException $e){
            return $this->sendError($e->getMessage());
        }
    }
    
    
    /**
     *  update profile
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function doUpdateProfile(Request $request)
    {
        try{
            if($request->user){
                $post = $request->all();
                // dd($post);
                $user = $request->user;
                $post['image'] = $request->file('image');
                $postData = array(
                    'updated_at' => date("Y-m-d H:i:s")
                );
                if(isset($post['email'])){
                    $checkuser = User::where('email', $request->input('email'))->where('id','!=',$user->id)->first();
                    if($checkuser) {
                        return $this->sendError(__('lang.message_email_already_exist'));
                    }
                    $postData['email'] = $post['email'];
                }                
                if(isset($post['name'])){
                    $postData['name'] = $post['name'];
                }
                if(isset($post['phone'])){
                    $postData['phone'] = $post['phone'];
                }                
                if(isset($post['image'])){
                    $uploadImage = \Helpers::uploadFiles($request->file('image'),'user/profile_pic/');
                    if($uploadImage['status']==true)
                    {
                        $postData['image'] = $uploadImage['file_name'];
                    }
                }
                if(isset($post['adharcard_image'])){
                    $uploadImage = \Helpers::uploadFiles($request->file('adharcard_image'),'user/adharcard_image/');
                    if($uploadImage['status']==true)
                    {
                        $postData['adharcard_image'] = $uploadImage['file_name'];
                    }
                }
                User::where('id',$user->id)->update($postData);
                $userProfile = User::where('id',$user->id)->first();
                if($userProfile){
                    if($userProfile->image!=''){
                        $userProfile->image = url('uploads/user/profile_pic/'.$userProfile->image);
                    }
                }
                if($userProfile){
                    if($userProfile->adharcard_image!=''){
                        $userProfile->adharcard_image = url('uploads/user/adharcard_image/'.$userProfile->adharcard_image);
                    }
                }
                return $this->sendResponse($userProfile, __('lang.message_profile_updated_successfully'));
            }
            return $this->sendError(__('lang.message_user_not_found'));
        } catch (\Exception $ex) {
            return $this->sendError($ex->getMessage());
        }
    }
    
}
