<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Auth;
use Validator;
use App\Models\User;
use App\Models\Hotel;
use App\Models\Category;
use App\Models\Booking;
use App\Models\Offer;
use App\Models\Aminity;
use App\Models\Slider;
use App\Models\Additional_Info;
use App\Models\Destination;
use Session;
use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;
use Symfony\Component\HttpFoundation\Response;

class DataAPIController extends Controller
{
    private $language;
    public function __construct()
    {
        // No need to call parent::__construct() here
        $this->language = request()->header('language-code') && request()->header('language-code') != '' ? request()->header('language-code') : 'en';
    }
    
    /**
     * Fetch list here
    **/
    public  function getAminityList(Request $request){
        try{
            $controller = new self(); // Creating an instance of HomeAPIController
            $pagination_no = config('constant.api_pagination');
            if(isset($search['per_page']) && !empty($search['per_page'])){
                $pagination_no = $search['per_page'];
            }
            $resData = Aminity::where('status',1)->select('id','name')->get();
            $response = $controller->sendResponse($resData, __('lang.message_data_retrived_successfully'));  
            return $response;
        } catch (\Exception $ex) {
            return $controller->sendError($ex->getMessage());
        }
    }
    
    /**
     * Fetch list here
    **/
    public  function getCategoryList(Request $request){
        try{
            $controller = new self(); // Creating an instance of HomeAPIController
            $pagination_no = config('constant.api_pagination');
            if(isset($search['per_page']) && !empty($search['per_page'])){
                $pagination_no = $search['per_page'];
            }
            $resData = Category::where('status',1)->select('id','name')->get();
            $response = $controller->sendResponse($resData, __('lang.message_data_retrived_successfully'));  
            return $response;
        } catch (\Exception $ex) {
            return $controller->sendError($ex->getMessage());
        }
    }
    
    /**
     * Fetch list here
    **/
    public  function getSliderList(Request $request){
        try{
            $controller = new self(); // Creating an instance of HomeAPIController
            $pagination_no = config('constant.api_pagination');
            if(isset($search['per_page']) && !empty($search['per_page'])){
                $pagination_no = $search['per_page'];
            }
            $resData = Slider::where('status',1)->get();
            if(count($resData)){
                foreach($resData as $row){
                    $row->image = url('/uploads/slider/'.$row->image) ?? null;
                }
            }
            $response = $controller->sendResponse($resData, __('lang.message_data_retrived_successfully'));  
            return $response;
        } catch (\Exception $ex) {
            return $controller->sendError($ex->getMessage());
        }
    }
    
    
    /**
     * Fetch list here
    **/
    public  function getOfferList(Request $request){
        try{
            $controller = new self(); // Creating an instance of HomeAPIController
            $pagination_no = config('constant.api_pagination');
            if(isset($search['per_page']) && !empty($search['per_page'])){
                $pagination_no = $search['per_page'];
            }
            $resData = Offer::where('status',1)->get();
            if(count($resData)){
                foreach($resData as $row){
                    $row->image = url('/uploads/offer/'.$row->image) ?? null;
                }
            }
            $response = $controller->sendResponse($resData, __('lang.message_data_retrived_successfully'));  
            return $response;
        } catch (\Exception $ex) {
            return $controller->sendError($ex->getMessage());
        }
    }



}
