@extends('admin.layouts.app')
@section('content')

<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">


    <form action="{{url('admin/save-package')}}" method="POST" enctype="multipart/form-data">
        @csrf

        <div class="row">
            <div class="col-md-6">
                <h4 class="py-3 mb-4">
                  <span class="text-muted fw-light">
                    <a href="{{url('admin/dashboard')}}">{{__('lang.admin_dashboard')}}</a> /
                  </span><span class="text-muted fw-light">
                    <a href="{{url('admin/items')}}">{{__('lang.admin_package_list')}}</a> /
                  </span>
                  {{__('lang.admin_add_package_form')}}</h4>
            </div>
            <div class="col-md-6">
                <div class="table-btn-css">
                    <button type="submit" class="btn btn-primary waves-effect waves-light">
                        <span class="ti-xs ti ti-plus me-1"></span>{{__('lang.admin_submit')}}
                    </button>
                </div>
            </div>
        </div>
        

        <!-- product add -->
          <div class="row">
                  <!-- First column-->
                  <div class="col-12 col-lg-8">

                    <!-- Product Information -->
                    <div class="card mb-4">
                      <div class="card-header">
                        <h5 class="card-tile mb-0">{{__('lang.admin_package_information')}}</h5>
                      </div>
                      <div class="card-body">
                        <!-- name -->
                        <div class="mb-3">
                          <label class="form-label" for="ecommerce-product-name">{{__('lang.admin_name')}}</label>
                          <input
                            type="text"
                            class="form-control"
                            id="ecommerce-product-name"
                            placeholder="{{__('lang.admin_name_placeholder')}}"
                            name="name"
                            aria-label="{{__('lang.admin_name')}}" />
                        </div>
                        
                        <!-- Description -->
                        <div class="mb-3">
                            <label class="form-label" for="short_description">{{__('lang.admin_description')}} </label>
                            <textarea class="form-control" name="short_description" id="editor" placeholder="{{__('lang.admin_short_description_placeholder')}}" row="6"></textarea> 
                        </div>

                      </div>
                    </div>
                    <!-- /Product Information -->
  
                  </div>
                  <!-- /Second column -->

                  <!-- Second column -->
                  <div class="col-12 col-lg-4">

                    <!-- Feature Info -->
                    <div class="card mb-4">
                      <div class="card-header">
                        <h5 class="card-title mb-0">{{__('lang.admin_feature_info')}}</h5>
                      </div>
                      <div class="card-body">

                        <!-- Feature -->
                        <div class="mb-3 col ecommerce-select2-dropdown">
                          <label
                            class="form-label mb-1 d-flex justify-content-between align-items-center"
                            for="category-org">
                            <span>{{__('lang.admin_feature')}}</span><a href="{{url('admin/feature')}}" class="fw-medium">{{__('lang.admin_add_new_feature')}}</a>
                          </label>
                          <select class="select2 form-select" multiple name="feature_id[]">
                            <option value="">{{__('lang.admin_select_feature')}}</option>
                            @foreach($feature_data as $row)
                            <option value="{{$row->id}}">{{$row->name}}</option>
                            @endforeach
                          </select>
                        </div>

                      </div>
                    </div>
                    <!-- /Feature Info -->

                  </div>
                  <!-- /Second column -->
                </div>
        <!-- end product add -->

    </form>
       

    </div>
    <!-- / Content -->
</div>
<!-- Content wrapper -->

@endsection
