<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('hotel_off_days')) {
            Schema::create('hotel_off_days', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('hotel_id')->default(0);
                $table->text('off_days')->nullable();
                $table->timestamps();
                
                // Foreign key constraints
                $table->foreign('hotel_id')->references('id')->on('hotels')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('hotel_off_days');
    }
};
