<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('packages')) {
            Schema::create('packages', function (Blueprint $table) {
                $table->id();
                $table->text('feature_id')->nullable();
                $table->string('name', 100)->nullable();
                $table->text('short_description')->nullable();
                $table->enum('status', [1, 0])->default(1);
                $table->timestamps();
                $table->softDeletes();

                // Adding indexes
                $table->index('name');
                $table->index('short_description');
                $table->index('status');
                $table->index('created_at');
                $table->index('updated_at');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('packages');
    }
};
