<?php

namespace App\Models; 

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;

class Wallet extends Model
{
    use HasFactory;
    protected $guarded = ['id'];
    protected $table = "wallets";

     public function customer()
    {
        return $this->belongsTo(User::class, 'customer_id');
    }

    
    /**
     * Fetch list of from here
    **/
    public static function getLists($search){
        try {
            
            $obj = new self;

            $pagination = (isset($search['perpage']))?$search['perpage']:config('constant.pagination');

            if(isset($search['customer_id']) && $search['customer_id']!=''){
                $obj = $obj->where('customer_id',$search['customer_id']);

                $data = $obj->with('customer')->orderBy('id', 'DESC')->paginate($pagination)->appends('perpage', $pagination);
            }else{
            $data = $obj->where('id',0)->with('customer')->orderBy('id', 'DESC')->paginate($pagination)->appends('perpage', $pagination);
            }
    
            return $data;
        }
        catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }

    /**
     * Add or update
    **/
    public static function addUpdate($data,$id=0) {
      
        try {
            $obj = new self;
            unset($data['_token']);
          
            if($id==0){
                $data['created_at'] = date('Y-m-d H:i:s');
                $id = $obj->insertGetId($data);
                return ['status' => true, 'message' => __('lang.admin_data_add_msg')];
            }
            else{
                $data['updated_at'] = date('Y-m-d H:i:s');
                $obj->where('id',$id)->update($data);
                return ['status' => true, 'message' => __('lang.admin_data_update_msg')];
            }  
        }
        catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }

}
