<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Hotel_Rules extends Model
{
    use HasFactory;

    protected $guarded = ['id']; 
    protected $table = "hotel_rules";

    // Define the relationship with the Feature model
    public function rules()
    {
        return $this->belongsTo(Rules::class, 'rules_id');
    }
    
    // Define the relationship with the Hotel model
    public function hotel()
    {
        return $this->belongsTo(Hotel::class, 'hotel_id');
    }
}
