<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Auth;
use Validator;
use App\Models\User;
use App\Models\Hotel;
use App\Models\Booking;
use App\Models\Additional_Info;
use App\Models\Destination;
use Session;
use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;
use Symfony\Component\HttpFoundation\Response;

class SearchAPIController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function getSearchHotelList(Request $request)
    {
        try {
            // Set default pagination
            $pagination_no = config('constant.api_pagination', 10);
    
            // Update pagination if per_page is set
            if ($request->has('per_page') && !empty($request->per_page)) {
                $pagination_no = (int) $request->per_page;
            }
    
            // Get search parameters
            $rooms = $request->room_count; // e.g., 2
            $guests = $request->guest_count; // e.g., 5
            $location = $request->location; // e.g., 'Indore, India'
            $start_date = $request->start_date; // e.g., '2024-06-25'
            $end_date = $request->end_date; // e.g., '2024-06-26'
    
            // Start building the query
            $query = Hotel::where('status', 1)
                ->with(['destination:id,name', 'aminities:id,name','ratings'])
                ->select('id', 'name', 'price', 'type', 'destination_id', 'category_id', 'front_image', 'room', 'max_guest', 'address');
    
            // Apply location filter
            if ($location && !empty($location)) {
                $query->where('address', 'LIKE', '%' . $location . '%');
            }
    
            // Apply guest count filter
            if ($guests && !empty($guests)) {
                $query->where('max_guest', '>=', $guests);
            }
    
            // Filter by room availability and date range
            if (($rooms && !empty($rooms)) || ($start_date && !empty($start_date) && $end_date && !empty($end_date))) {
                $hotels = $query->get();
    
                // Filter hotels based on room availability and date range
                $filteredHotels = $hotels->filter(function ($hotel) use ($rooms, $start_date, $end_date) {
                    // Calculate available rooms
                    $bookedRooms = Booking::where('hotel_id', $hotel->id)
                        ->where(function ($query) use ($start_date, $end_date) {
                            $query->whereBetween('start_date', [$start_date, $end_date])
                                ->orWhereBetween('end_date', [$start_date, $end_date])
                                ->orWhere(function ($query) use ($start_date, $end_date) {
                                    $query->where('start_date', '<=', $start_date)
                                        ->where('end_date', '>=', $end_date);
                                });
                        })
                        ->sum('room');
  
            
                    $availableRooms = $hotel->room - $bookedRooms;
    
                    // Check if enough rooms are available
                    return $availableRooms >= $rooms;
                });
    
                $hotels = $filteredHotels;
            } else {
                // Get the results with pagination
                $hotels = $query->paginate($pagination_no);
            }
    
            // Process each hotel to add required data
            $hotels->transform(function ($hotel) {
                $hotel->front_image = url('uploads/hotel/front_image/' . $hotel->front_image);
                if ($hotel->destination) {
                    $hotel->destination = [
                        'id' => $hotel->destination->id,
                        'name' => $hotel->destination->name
                    ];
                }
                    // Calculate and add average rating
            $hotel->average_rating = $hotel->ratings->avg('rating') ?? null;

            // Remove ratings data from the response
            unset($hotel->ratings);
                return $hotel;
            });
    
            // Send response
            return $this->sendResponse($hotels, __('lang.message_data_retrived_successfully'));
        } catch (\Exception $ex) {
            // Send error response
            return $this->sendError($ex->getMessage());
        }
    }



}
